;********************************************************
;
;             The signboaRD control processing
;
; Author : Seiichi Inoue   :  
;********************************************************

        list            p=pic16f84a
        include         p16f84a.inc
       __config _HS_OSC & _WDT_OFF & _PWRTE_ON & _CP_OFF

;****************  Label Definition  ********************
lpcnt   equ     0c              ;Screen loop counter adr
scrnidx equ     0d              ;Screen data index adr
w_save  equ     0e              ;W register save adr
s_save  equ     0f              ;STATUS reg save adr
scrnhd  equ     10              ;Screen table head adr
tm_cnt  equ     20              ;Time adjust counter adr
e_adr   equ     21              ;EEPROM data adr
e_check equ     22              ;EEPROM end check cnt adr
s_loop  equ     23              ;Screen data loop cnt adr
s_index equ     24              ;Screen table index adr
s_work  equ     25              ;Screen data work area

;************************
;*     Time adjust      *
;************************
;This data decides a scroll speed. Basic rate is 26msec.
tm_adj  equ     0c              ;Time adjust(26msec x 12)


;************************
;*   EEPROM data size   *
;************************
;If the data size is 30 bytes, then simply set d'30'.
e_size  equ    d'32'            ;EEPROM data size

;***************  EEPROM Data Definition  ***************
        org     h'2100'
        de      b'11111111'
        de      b'11111111'
        de      b'11100111'
        de      b'11000011'
        de      b'10000001'
        de      b'10000001'
        de      b'11000011'
        de      b'11100111'
        de      b'11111111'
        de      b'11111111'
        de      b'01111110'
        de      b'00000000'
        de      b'01111110'
        de      b'11111111'
        de      b'11110111'
        de      b'00000111'
        de      b'11110111'
        de      b'00000111'
        de      b'11111111'
        de      b'00000111'
        de      b'01110111'
        de      b'00000111'
        de      b'11111111'
        de      b'00000111'
        de      b'01111111'
        de      b'00000111'
        de      b'11111111'
        de      b'00000111'
        de      b'01010111'
        de      b'01000111'
        de      b'11111111'
        de      b'11111111'

;****************  Program Start  ***********************
        org     0               ;Reset Vector
        goto    init
        org     4               ;Interrupt Vector
        goto    int

;****************  Initial Process  *********************
        org     5
init    bsf     STATUS,RP0      ;Change to Bank1
        clrf    TRISA           ;Set PORTA to Output mode
        clrf    TRISB           ;Set PORTB to Output mode
        movlw   h'07'           ;TOCS=0,PSA=0,PS2/1/0=111
        movwf   OPTION_REG      ;Set timer condition
        bcf     STATUS,RP0      ;Change to Bank0
        movlw   h'00'           ;Set timer value
        movwf   TMR0            ;TMR0 = 0 (255 counts)
        movlw   tm_adj          ;Set time adjust value
        movwf   tm_cnt          ;Save time adjust
        clrf    e_adr           ;Clear EEPROM data adr
        movlw   e_size          ;Set EEPROM data size
        movwf   e_check         ;Save EEPROM end check
        movlw   h'a0'           ;GIE=1,TOIE=1
        movwf   INTCON          ;Interruption enable

;**************  Screen Load Process  *******************
screen  bsf     INTCON,GIE      ;Interrupt enable
        movlw   d'16'           ;Set loop count
        movwf   lpcnt           ;Save loop count
        movlw   h'0f'           ;Set screen index
        movwf   scrnidx         ;Save index
        bcf     INTCON,GIE      ;Interrupt disable
scrnlp  movlw   h'ff'           ;Set LED OFF data
        movwf   PORTB           ;Output Data
        movf    scrnidx,w       ;Set Position
        movwf   PORTA           ;Output Position
        movlw   scrnhd          ;Set Table head address
        addwf   scrnidx,w       ;Head + Index
        movwf   FSR             ;Set Table address
        movf    INDF,w          ;Read Data
        movwf   PORTB           ;Output Data
        decf    scrnidx,f       ;Index - 1
        decfsz  lpcnt,f         ;Loop end ?
        goto    scrnlp          ;No. Next line
        goto    screen          ;Yes. Next screen

;************  Begin Interruption Process  **************
int     movwf   w_save          ;Save W register
        movf    STATUS,w        ;Read STATUS reg
        movwf   s_save          ;Save STATUS reg
        btfsc   INTCON,T0IF     ;Time out interruption ?
        goto    timer_int       ;Jump to Timer process
        goto    init            ;Reset(Illegal interrupt)

;************  END of Interruption Process **************
int_end movf    s_save,w        ;Read saved STATUS reg
        movwf   STATUS          ;Recover STATUS reg
        swapf   w_save,f        ;Read saved W register
        swapf   w_save,w        ;Recover W register
        retfie        
        
;***********  Time-out interruption Process  ************
timer_int
        bcf     INTCON,T0IF     ;Clear timer int flag
        movlw   h'00'           ;Set timer value
        movwf   TMR0            ;TMR0 = 0 (255 counts)
        decfsz  tm_cnt,f        ;Time over ?
        goto    int_end         ;No. Retry
        movlw   tm_adj          ;Set time adjust value
        movwf   tm_cnt          ;Save time adjust

;************  Screen data shift Process  ***************
        movlw   d'15'           ;Set loop count
        movwf   s_loop          ;Save loop count
        movlw   scrnhd          ;Set screen head adr
        movwf   s_index         ;Set screen adr
loop    incf    s_index,w       ;Inclement index
        movwf   FSR             ;Set read addres
        movf    INDF,w          ;Read data
        movwf   s_work          ;Save data
        movf    s_index,w       ;Read index
        movwf   FSR             ;Set write address
        movf    s_work,w        ;Recover data
        movwf   INDF            ;Write data
        incf    s_index,f       ;Inclement index
        decfsz  s_loop,f        ;All shifted ?
        goto    loop            ;No. Continue.

;**************  New data write Process  ****************
        movf    s_index,w       ;Read index
        movwf   FSR             ;Set write address
        movf    e_adr,w         ;Read EEPROM address
        movwf   EEADR           ;Set EEPROM address
        bsf     STATUS,RP0      ;Change to Bank1
        bsf     EECON1,RD       ;Start EEPROM reading
        bcf     STATUS,RP0      ;Change to Bank0
        movf    EEDATA,w        ;Read EEPROM data
        movwf   INDF            ;Write new data
        incf    e_adr,f         ;Inclement data address
        decfsz  e_check,f       ;End of EEPROM data ?
        goto    int_end         ;No. Return
        clrf    e_adr           ;Clear EEPROM data adr
        movlw   e_size          ;Set EEPROM data size
        movwf   e_check         ;Save EEPROM end check
        goto    int_end         ;Return

;********************************************************
;          END of signboaRD control processing
;********************************************************

        end
