;Source code file of LED flasher


 ;********************************************************
;
;            The LED flash control processing
;
;                                 Author : Seiichi Inoue
;
;********************************************************

        list            p=pic16f84a
        include         p16f84a.inc
        __config _HS_OSC & _WDT_OFF & _PWRTE_ON & _CP_OFF
        errorlevel      -302    ;Eliminate bank warning

;****************  Label Definition  ********************
ra0     equ     00              ;RA0 bit
ra1     equ     01              ;RA1 bit
ra2     equ     02              ;RA2 bit
ra3     equ     03              ;RA3 bit
ra4     equ     04              ;RA4 bit
cnt500u equ     0c              ;500usec counter Address
cnt1m   equ     0d              ;1msec counter Address
cnt100m equ     0e              ;100msec counter Address
cnt500m equ     0f              ;500msec counter Address
cnt1s   equ     10              ;1sec counter Address

;*************  Pattern Data Definition  ****************
;                 '1':OFF   '0':ON

;******  Pattern 0  ******
p00     equ     b'11111110'
p01     equ     b'11111101'
p02     equ     b'11111011'
p03     equ     b'11110111'
p04     equ     b'11101111'
p05     equ     b'11011111'
p06     equ     b'10111111'
p07     equ     b'01111111'

;******  Pattern 1  ******
p10     equ     b'01111111'
p11     equ     b'10111111'
p12     equ     b'11011111'
p13     equ     b'11101111'
p14     equ     b'11110111'
p15     equ     b'11111011'
p16     equ     b'11111101'
p17     equ     b'11111110'

;******  Pattern 2  ******
p20     equ     b'01111110'
p21     equ     b'10111101'
p22     equ     b'11011011'
p23     equ     b'11100111'
p24     equ     b'11011011'
p25     equ     b'10111101'
p26     equ     b'01111110'

;******  Pattern 3  ******
p30     equ     b'11111110'
p31     equ     b'11111101'
p32     equ     b'11111010'
p33     equ     b'11110101'
p34     equ     b'11101010'
p35     equ     b'11010101'
p36     equ     b'10101010'
p37     equ     b'01010101'
p38     equ     b'10101011'
p39     equ     b'01010111'
p3a     equ     b'10101111'
p3b     equ     b'01011111'
p3c     equ     b'10111111'
p3d     equ     b'01111111'

;******  Pattern 4  ******
p40     equ     b'00000000'
p41     equ     b'11111111'
p42     equ     b'00000000'
p43     equ     b'11111111'
p44     equ     b'00000000'
p45     equ     b'11111111'
p46     equ     b'00000000'
p47     equ     b'11111111'
p48     equ     b'00000000'


;****************  Program Start  ***********************
        org     0               ;Reset Vector
        goto    init
        org     4               ;Interrupt Vector
        goto    init

;****************  Initial Process  *********************
        org     5
init    bsf     STATUS,RP0      ;Change to Bank1 
        movlw   h'ff'           ;Set input mode data
        movwf   TRISA           ;Set PORTA to Input mode
        clrf    TRISB           ;Set PORTB to Output mode
        bcf     STATUS,RP0      ;Change to Bank0
        movlw   h'ff'           ;Set LED off data
        movwf   PORTB           ;Output data

;****************  Key Scan Process  ********************
keyscan btfss   PORTA,ra0       ;RA0 ON(Low lebel) ?
        call    ptn0            ;Yes. Call Pattern 0
        btfss   PORTA,ra1       ;RA1 ON ?
        call    ptn1            ;Yes. Call Pattern 1
        btfss   PORTA,ra2       ;RA2 ON ?
        call    ptn2            ;Yes. Call Pattern 2
        btfss   PORTA,ra3       ;RA3 ON ?
        call    ptn3            ;Yes. Call Pattern 3
        btfss   PORTA,ra4       ;RA4 ON ?
        call    ptn4            ;Yes. Call Pattern 4
        goto    keyscan         ;Retry

;***********  Pattern 0 Output Subroutine ***************
ptn0    movlw   p00             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p01             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p02             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p03             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p04             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p05             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p06             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p07             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   h'ff'           ;Set LED off data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        return

;***********  Pattern 1 Output Subroutine ***************
ptn1    movlw   p10             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p11             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p12             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p13             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p14             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p15             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p16             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p17             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   h'ff'           ;Set LED off data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        return

;***********  Pattern 2 Output Subroutine ***************
ptn2    movlw   p20             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p21             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p22             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p23             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p24             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p25             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p26             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   h'ff'           ;Set LED off data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        return

;***********  Pattern 3 Output Subroutine ***************
ptn3    movlw   p30             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p31             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p32             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p33             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p34             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p35             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p36             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p37             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p38             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p39             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p3a             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p3b             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p3c             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   p3d             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        movlw   h'ff'           ;Set LED off data
        movwf   PORTB           ;Output data
        call    t100m           ;Wait 100msec
        return

;***********  Pattern 4 Output Subroutine ***************
ptn4    movlw   p40             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   p41             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   p42             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   p43             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   p44             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   p45             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   p46             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   p47             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   p48             ;Set pattern data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        movlw   h'ff'           ;Set LED off data
        movwf   PORTB           ;Output data
        call    t1s             ;Wait 1sec
        return

;********************************************************
;          Timer  Subroutine for 10MHz clock
;********************************************************

;*************  1msec Timer Subroutine  *****************
t1m     movlw   d'2'            ;(1)       Set loop cnt1
        movwf   cnt1m           ;(1)       Save loop cnt1
tm1lp1  movlw   d'249'          ;(1)*2     Set loop cnt2
        movwf   cnt500u         ;(1)*2     Save loop cnt2
tm1lp2  nop                     ;(1)*249*2 Time adjust
        nop                     ;(1)*249*2 Time adjust
        decfsz  cnt500u,f       ;(1)*249*2 cnt500u-1=0 ?
        goto    tm1lp2          ;(2)*248*2 No, continue
        decfsz  cnt1m,f         ;(1)*2     cnt1m-1=0 ?
        goto    tm1lp1          ;(2)       No. Continue
        return                  ;(2)       Yes. Cnt end
                                ;Total 2501*0.4usec=1msec

;*************  100msec Timer Subroutine  ***************
t100m   movlw   d'100'          ;Set loop counter
        movwf   cnt100m         ;Save loop counter
tm2lp   call    t1m             ;1msec subroutine
        decfsz  cnt100m,f       ;cnt100m - 1 = 0 ?
        goto    tm2lp           ;No. Continue
        return                  ;Yes. Count end


;*************  500msec Timer Subroutine  ***************
t500m   movlw   d'5'            ;Set loop counter
        movwf   cnt500m         ;Save loop counter
tm3lp   call    t100m           ;100msec subroutine
        decfsz  cnt500m,f       ;cnt500m - 1 = 0 ?
        goto    tm3lp           ;No. Continue
        return                  ;Yes. Count end

;**************  1sec Timer Subroutine  *****************
t1s     movlw   d'2'            ;Set loop counter
        movwf   cnt1s           ;Save loop counter
tm4lp   call    t500m           ;500msec subroutine
        decfsz  cnt1s,f         ;cnt1s - 1 = 0 ?
        goto    tm4lp           ;No. Continue
        return                  ;Yes. Count end


;********************************************************
;          END of LED flash control processing
;********************************************************

        end
 
